"use client";

import { useEffect } from "react";
import Header from "./components/Header";
import Company from "./components/Company";
import About from "./components/About";
import Products from "./components/Products";
import Services from "./components/Services";
import Experience from "./components/Experience";
import Contact from "./components/Contact";
import Footer from "./components/Footer";

export default function Home() {
    useEffect(() => {
        // Handle hash navigation
        if (window.location.hash) {
            const hash = window.location.hash.slice(1);
            const element = document.getElementById(hash);
            if (element) {
                // Small delay to ensure page is rendered
                setTimeout(() => {
                    const rect = element.getBoundingClientRect();
                    const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                    const top = rect.top + scrollTop;
                    
                    window.scrollTo({
                        top,
                        behavior: "smooth"
                    });
                }, 100);
            }
        } else {
            window.scrollTo(0, 0);
        }
        
        if (window.location.pathname !== '/' || window.location.search) {
            window.history.replaceState({}, '', window.location.pathname + window.location.hash);
        }
    }, []);

    return (
        <div>
            <Header />
            <div id="company">
                <Company />
            </div>
            <div id="about">
                <About />
            </div>
            <div id="services">
                <Products />
                <Services />
            </div>
            <Experience />
            <div id="contact">
              <Contact />
            </div>
            <Footer />
        </div>
    );
}
