"use client";

import { MapPin, Phone, Mail } from "lucide-react";

export default function Footer() {
    const contactInfo = [
        {
            type: "Address",
            content: "Office No. G-07, Ground floor, Sarah Building, Al Garhoud, Dubai, United Arab Emirates.",
            link: "https://maps.google.com/?q=Office+No.+G-07,+Ground+floor,+Sarah+Building,+Al+Garhoud,+Dubai,+United+Arab+Emirates",
            icon: MapPin,
        },
        {
            type: "Telephone",
            content: "+971 4 5660633",
            link: "tel:+97145660633",
            icon: Phone,
        },
        {
            type: "Email",
            content: "info@ckegeneral.com",
            link: "mailto:info@ckegeneral.com",
            icon: Mail,
        },
    ];

    return (
        <footer className="w-full pt-12 pb-8 px-10 bg-[#F4F4F4]">
            <div className="max-w-7xl mx-auto">
                <div className="flex flex-col items-center gap-8">
                    {/* Contact Info */}
                    <div className="grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-12 w-full max-w-5xl">
                        {contactInfo.map((info, index) => {
                            const IconComponent = info.icon;
                            return (
                                <div
                                    key={index}
                                    className="flex flex-col items-center text-center"
                                >
                                    <div className="flex items-center gap-2 mb-3">
                                        <IconComponent className="w-4 h-4 text-gray-700" />
                                        <h3 className="text-sm font-medium text-gray-800">
                                            {info.type}
                                        </h3>
                                    </div>
                                    <a
                                        href={info.link}
                                        target={info.type === "Address" ? "_blank" : undefined}
                                        rel={info.type === "Address" ? "noopener noreferrer" : undefined}
                                        className="text-xs md:text-sm text-gray-600 leading-relaxed hover:text-black transition-colors"
                                    >
                                        {info.content}
                                    </a>
                                </div>
                            );
                        })}
                    </div>
                    
                    <p className="text-sm font-semibold text-gray-700 mt-8">
                        CKE General Trading® 2025
                    </p>
                </div>
            </div>
        </footer>
    );
}

