"use client";

import Image from "next/image";
import Button from "./Button";

export default function Experience() {
    return (
        <section className="w-full py-16 md:py-24 bg-[#f4f4f4]">
            <div className="max-w-7xl mx-auto px-5">
                <div className="grid grid-cols-1 md:grid-cols-2 gap-8 md:gap-12 items-center">
                    {/* Text Content */}
                    <div className="sm:text-left text-center md:text-left order-2 md:order-1">
                        <h2 className="text-3xl md:text-4xl lg:text-5xl font-light mb-6">
                            Experience Trusted Trade Solutions and Global Reach
                        </h2>
                        
                        <p className="text-lg md:text-xl text-gray-600 mb-8 leading-relaxed">
                            Discover how CKE General Trading LLC provides seamless import/export services, expert product sourcing, and reliable logistics that empower your business with quality and efficiency.
                        </p>

                        {/* Bullet Points */}
                        <ul className="space-y-4 mb-8 text-center md:text-left">
                            <li className="flex items-start justify-center md:justify-start">
                                <span className="mr-3 text-gray-400 mt-1">•</span>
                                <span className="text-base md:text-lg text-gray-700">
                                    Comprehensive supply-chain management tailored to your needs
                                </span>
                            </li>
                            <li className="flex items-start justify-center md:justify-start">
                                <span className="mr-3 text-gray-400 mt-1">•</span>
                                <span className="text-base md:text-lg text-gray-700">
                                    Access to diverse sectors including solar, industrial, and chemical products
                                </span>
                            </li>
                            <li className="flex items-start justify-center md:justify-start">
                                <span className="mr-3 text-gray-400 mt-1">•</span>
                                <span className="text-base md:text-lg text-gray-700">
                                    Commitment to integrity, transparency, and customer satisfaction
                                </span>
                            </li>
                            <li className="flex items-start justify-center md:justify-start">
                                <span className="mr-3 text-gray-400 mt-1">•</span>
                                <span className="text-base md:text-lg text-gray-700">
                                    Dependable worldwide logistics ensuring timely delivery
                                </span>
                            </li>
                        </ul>

                        <div className="flex justify-center md:justify-start">
                            <Button text="Explore Services" link="#services" dark={true} />
                        </div>
                    </div>

                    {/* Image */}
                    <div className="order-1 md:order-2 w-full h-full min-h-[400px] md:min-h-[500px] relative rounded-lg overflow-hidden">
                        <Image
                            src="https://images.unsplash.com/photo-1606185540834-d6e7483ee1a4?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D"
                            alt="Global trade and logistics"
                            fill
                            className="object-cover"
                            sizes="(max-width: 768px) 100vw, 50vw"
                        />
                    </div>
                </div>
            </div>
        </section>
    );
}

