"use client";

import { useState } from "react";

export default function Contact() {
    const [formData, setFormData] = useState({
        fullName: "",
        subject: "",
        message: "",
    });

    const handleChange = (
        e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>
    ) => {
        setFormData({
            ...formData,
            [e.target.name]: e.target.value,
        });
    };

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        
        const email = "info@ckegeneral.com";
        const subject = encodeURIComponent(
            formData.subject || "Contact from CKE General Trading Website"
        );
        const body = encodeURIComponent(
            `Full Name: ${formData.fullName}\n` +
            `Message:\n${formData.message}`
        );
        
        window.location.href = `mailto:${email}?subject=${subject}&body=${body}`;
    };

    return (
        <section className="w-full py-16 md:py-24 bg-white">
            <div className="max-w-7xl mx-auto px-5">
                <h2 className="text-3xl md:text-4xl lg:text-5xl font-light text-center mb-12">
                    Get In Touch
                </h2>

                <div className="max-w-2xl mx-auto">
                    <form onSubmit={handleSubmit} className="space-y-6">
                        {/* Full Name */}
                        <input
                            type="text"
                            name="fullName"
                            placeholder="Full Name"
                            value={formData.fullName}
                            onChange={handleChange}
                            className="w-full px-0 py-3 bg-transparent border-0 border-b border-gray-300 focus:outline-none focus:border-black transition-colors duration-200 text-base md:text-lg rounded-none"
                        />

                        {/* Subject */}
                        <input
                            type="text"
                            name="subject"
                            placeholder="Subject"
                            value={formData.subject}
                            onChange={handleChange}
                            className="w-full px-0 py-3 bg-transparent border-0 border-b border-gray-300 focus:outline-none focus:border-black transition-colors duration-200 text-base md:text-lg rounded-none"
                        />

                        {/* Message */}
                        <textarea
                            name="message"
                            placeholder="Message"
                            value={formData.message}
                            onChange={handleChange}
                            rows={6}
                            className="w-full px-0 py-3 bg-transparent border-0 border-b border-gray-300 focus:outline-none focus:border-black transition-colors duration-200 text-base md:text-lg rounded-none resize-none"
                        />

                        {/* Submit Button */}
                        <div className="flex justify-center pt-4">
                            <button
                                type="submit"
                                className="px-6 py-2 bg-black text-white border border-[#222] rounded-full text-base font-light cursor-pointer transition-all duration-200 hover:shadow-[0_0_16px_2px_rgba(160,160,160,0.6)] hover:border-[#aaa]"
                            >
                                Send Message
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    );
}

