"use client";

import Button from "./Button";

export default function Company() {
    return (
        <section
            className="relative w-full h-screen flex items-center justify-center"
            style={{
                backgroundImage: `url('https://images.unsplash.com/photo-1565793298595-6a879b1d9492?ixid=M3w0MzUxNjF8MHwxfHNlYXJjaHwxfHxsb2dpc3RpY3N8ZW58MHx8fHwxNzYyNzg1MzI2fDA&ixlib=rb-4.1.0&orientation=landscape?fit=crop&crop=entropy%2Cfaces&auto=format%2Ccompress&w=1280')`,
                backgroundSize: 'cover',
                backgroundPosition: 'center',
                backgroundRepeat: 'no-repeat',
            }}
        >
            <div className="absolute inset-0 bg-black/80" />
            
            <div className="relative z-10 max-w-4xl mx-auto px-6 text-center">
                <p className="text-white text-lg md:text-xl lg:text-2xl leading-relaxed mb-8 font-light">
                    CKE General Trading delivers trusted import and export services with unmatched integrity and efficiency, connecting global markets through expert sourcing and dependable logistics.
                </p>
                <Button text="Learn More" link="#about" dark={false} />
            </div>
        </section>
    );
}

