"use client";

import { useEffect, useState } from 'react';

export default function About() {
    const [isMobile, setIsMobile] = useState(false);

    useEffect(() => {
        // Check if device is mobile
        const checkMobile = () => {
            const isMobileDevice = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(
                navigator.userAgent
            ) || window.innerWidth < 768;
            setIsMobile(isMobileDevice);
        };

        checkMobile();
        window.addEventListener('resize', checkMobile);
        return () => window.removeEventListener('resize', checkMobile);
    }, []);

    return (
        <section className="relative w-full">
            <div className="h-[20vh] bg-white flex items-center justify-center">
                <h2 className="text-3xl md:text-4xl lg:text-5xl font-light text-center px-6">
                    Building Trust Through Clear and Honest Deals
                </h2>
            </div>

            <div className="relative h-[80vh] w-full overflow-hidden bg-black">

                    <video
                        autoPlay
                        loop
                        muted
                        playsInline
                        className="absolute inset-0 w-full h-full object-cover z-0"
                    >
                        <source src="/video.mp4" type="video/mp4" />
                    </video>

                <div className="absolute inset-0 bg-black/60 z-[1]" />

                <div className="relative z-10 h-full flex items-center justify-center">
                    <div className="max-w-4xl mx-auto px-6 text-center">
                        <p className="text-white text-lg md:text-xl lg:text-2xl leading-relaxed font-light">
                            CKE General Trading LLC is committed to integrity, transparency, and customer focus. We specialize in import/export, wholesale distribution, and supply-chain solutions across solar, industrial, and chemical sectors, ensuring quality and reliability in every partnership.
                        </p>
                    </div>
                </div>
            </div>
        </section>
    );
}

